package coreservlets.listeners;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;

/** Proces nasuchujcy monitoruje zmiany nazwy firmy
 *  (nazwa jest przechowywana jako warto atrybutu
 *  companyName kontekstu serwletu).
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class ChangedCompanyNameListener
    implements ServletContextAttributeListener {

  /** Gdy warto atrybutu companyName zostanie zmieniona,
   *  jego warto dotychczasowa zostanie przypisana
   *  atrybutowi formerCompanyName.
   */
  public void attributeReplaced
                   (ServletContextAttributeEvent event) {
    if (event.getName().equals("companyName")) {
      String oldName = (String)event.getValue();
      ServletContext context = event.getServletContext();
      context.setAttribute("formerCompanyName", oldName);
    }
  }

  public void attributeAdded
                   (ServletContextAttributeEvent event) {}
  
  public void attributeRemoved
                   (ServletContextAttributeEvent event) {}
}
